#include "Blender.au3"
#include <Misc.au3>

_Blender_Startup()

$Scene = _Blender_GetScene("Scene")

$aRenderInfo = _Blender_SceneGetRenderInfo($Scene)
$aOutInfo = _Blender_SceneGetOutputInfo($Scene)

ConsoleWrite("Image Width: "&$aRenderInfo[$BUDF_RENDERINF_WIDTH]&@CRLF)
ConsoleWrite("Image Height: "&$aRenderInfo[$BUDF_RENDERINF_HEIGHT]&@CRLF)
ConsoleWrite("Image Size %: "&$aRenderInfo[$BUDF_RENDERINF_PERCENTAGE]&@CRLF)
ConsoleWrite("Framerate: "&$aRenderInfo[$BUDF_RENDERINF_FPS]&@CRLF)

ConsoleWrite("Output Format: "&$aOutInfo[$BUDF_OUTINF_FORMAT]&@CRLF&@CRLF)

$aRenderInfo[$BUDF_RENDERINF_WIDTH] = 1280
$aRenderInfo[$BUDF_RENDERINF_HEIGHT] = 720
$aRenderInfo[$BUDF_RENDERINF_PERCENTAGE] = 100
$aRenderInfo[$BUDF_RENDERINF_FPS] = 60

$aOutInfo[$BUDF_OUTINF_FORMAT] = "JPEG"

_Blender_SceneSetRenderInfo($Scene, $aRenderInfo)
_Blender_SceneSetOutputInfo($Scene, $aOutInfo)

ConsoleWrite("Image Width: "&$aRenderInfo[$BUDF_RENDERINF_WIDTH]&@CRLF)
ConsoleWrite("Image Height: "&$aRenderInfo[$BUDF_RENDERINF_HEIGHT]&@CRLF)
ConsoleWrite("Image Size %: "&$aRenderInfo[$BUDF_RENDERINF_PERCENTAGE]&@CRLF)
ConsoleWrite("Framerate: "&$aRenderInfo[$BUDF_RENDERINF_FPS]&@CRLF)

ConsoleWrite("Output Format: "&$aOutInfo[$BUDF_OUTINF_FORMAT]&@CRLF)

_Blender_Shutdown()